<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentItem;
use Drupal\file\Entity\File;

/**
 * Provides 'Image Comparison' component.
 *
 * @ComponentBuilder(
 *   id = "image_comparison",
 *   label = @Translation("Image Comparison"),
 *   group = @Translation("Content style (paragraph style)"),
 *   category = @Translation("Content style (paragraph style)"),
 *   template = "image_comparison",
 * )
 */
class ImageComparison extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_item'])) {
      $component_item = $variables['elements']['#component_item'];
      if ($component_item instanceof ComponentItem) {
        $field_2_images = $component_item->get('field_2_images')->getValue();
        foreach ($field_2_images as $field) {
          $image_info = [];
          $image_info['alt'] = $field['alt'];
          $image_info['width'] = $field['width'];
          $image_info['height'] = $field['height'];
          $file = File::load($field['target_id']);
          $uri = $file->getFileUri();
          $image_info["src"] = str_replace('public://', '', $uri);
          $variables['content']['image'][] = $image_info;
        }

      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_image_comparison/assets/css/foundation.css' => [],
          'components/component_image_comparison/assets/css/twentytwenty.css' => [],
          'components/component_image_comparison/assets/css/twentytwenty-no-compass.css' => [],
          'components/component_image_comparison/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_image_comparison/assets/js/jquery.twentytwenty.js' => [],
        'components/component_image_comparison/assets/js/jquery.event.move.js' => [],
        'components/component_image_comparison/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
