<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Jump to' component.
 *
 * @ComponentBuilder(
 *   id = "jump_to",
 *   label = @Translation("Jump to"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "jump_to",
 *   single_value = TRUE,
 *   alter_wrapper = TRUE
 * )
 */
class JumpTo extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_jump_to/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_jump_to/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
