<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Launching Soon' component.
 *
 * @ComponentBuilder(
 *   id = "launching_soon",
 *   label = @Translation("Launching Soon"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   single_value = TRUE,
 *   template = "launching_soon"
 * )
 */
class LaunchingSoon extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_launching_soon/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_launching_soon/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
