<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Sidebar Link Text' component.
 *
 * @ComponentBuilder(
 *   id = "sidebar_link_text",
 *   label = @Translation("Sidebar Link Text"),
 *   group = @Translation("Sidebar"),
 *   category = @Translation("Sidebar"),
 *   template = "sidebar_link_text",
 *   single_value = TRUE,
 * )
 */
class SidebarLinkText extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_sidebar_link_text/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_sidebar_link_text/assets/style.js' => [],
      ],
      "version" => "VERSION",
    ];
  }

}
