/**
 * @file
 * Javascript functionality for component carousel.
 */

(function ($, Drupal) {

  'use strict';

  Drupal.componentFixedTopbar = Drupal.componentFixedTopbar || {};
  Drupal.behaviors.fixedtopbar = {
    attach: function (context) {
      Drupal.componentFixedTopbar.handleFixedTopbar();
    }
  }

  Drupal.componentFixedTopbar.handleFixedTopbar = function () {
    const $component_fixed_topbar = $('.component-item--type-fixed-topbar');
    const windowWidth = window.innerWidth;
    const $item1 = $('#toolbar-bar');
    const $item2 = $('#toolbar-item-administration-tray');
    // const $item3 = $('#header .sticky-header-toggle');
    const $item3 = $('.sticky-header-toggle');

    if ($component_fixed_topbar.length) {
      let previousHeihgt = 0;
      if (windowWidth > 450) {
        if ($item1.outerHeight() > 0) {
          previousHeihgt += $item1.outerHeight();
        }
      }
      if (windowWidth > 900) {
        if ($item2.outerHeight() > 0) {
          previousHeihgt += $item2.outerHeight();
        }
      }

      $component_fixed_topbar.each(function () {
        let $this = $(this);
        $this.css('width', windowWidth);
        // $(window).scroll(function (event) {
        //   var scroll = $(window).scrollTop();
        //   if (scroll) {
        //     if ($item3.outerHeight() > 0) {
        //       initialHeight += $item3.outerHeight();
        //     }
        //   }
        //   else {
        //     let $newVal = $item3.find('button.sticky-header-toggle');
        //     let difLength = 0;
        //     if ($newVal.length) {
        //       difLength = $newVal.outerHeight();
        //     }
        //     initialHeight -= ($item3.outerHeight() - difLength);
        //     $this.css('top', previousHeihgt);
        //   }
        // });
        $this.css('top', previousHeihgt);
        // if ($item3.outerHeight() > 0) {
        //   let $left = $item3.outerWidth();
        //   $this.css('left', $left);
        // }
        // else {
        //   $this.css('left', 0);
        // }
        $this.css('left', 0);
        $this.css('position', 'fixed');
        previousHeihgt = $this.outerHeight() + previousHeihgt;
      });
    }
  };

})(jQuery, Drupal);
