/**
 * @file
 * Javascript functionality for component tab content.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentTabContent = Drupal.componentTabContent || {};
  Drupal.behaviors.tab_content = {
    attach: function (context) {
      Drupal.componentTabContent.tab_content(context);
    }
  }
  Drupal.componentTabContent.tab_content = function (context) {
    const $tab_content = $(once('tabsItems', '.component-wrapper--type-tabs.component-builder--type-tabs--parent', context));
    if ($tab_content.length > 0) {
      $tab_content.each(function () {
        const $this = $(this);
        $this.find('.component-wrapper--type-tabs .field--name-field-tabs').addClass('row');
        const column_class = $this.attr('tab-content-columns');
        $this.find('.component-wrapper--type-tabs .field--name-field-tabs > .field__item').addClass(column_class);
      })
    }
  }

})(jQuery, Drupal, once);
