<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Business Hours' component.
 *
 * @ComponentBuilder(
 *   id = "business_hours",
 *   label = @Translation("Business Hours"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   single_value = TRUE,
 *   template = "business_hours"
 * )
 */
class BusinessHours extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_business_hours/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_business_hours/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
