<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Download' component.
 *
 * @ComponentBuilder(
 *   id = "download",
 *   label = @Translation("Download"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   single_value = TRUE,
 *   template = "download"
 * )
 */
class Download extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_item'])) {
      $variables['#attached']['drupalSettings']['components']['download']['icons'] = [
        'pdf' => $this->getComponentPath() . '/assets/images/pdf-icon.png',
        'docx' => $this->getComponentPath() . '/assets/images/docx-icon.png',
        'xlsx' => $this->getComponentPath() . '/assets/images/excel-icon.png',
        'file' => $this->getComponentPath() . '/assets/images/file-icon.png',
        'image' => $this->getComponentPath() . '/assets/images/image-icon.png',
        'music' => $this->getComponentPath() . '/assets/images/music-icon.png',
        'txt' => $this->getComponentPath() . '/assets/images/txt-icon.png',
      ];
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_download/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_download/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
