<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Playlist' component.
 *
 * @ComponentBuilder(
 *   id = "playlist",
 *   label = @Translation("Playlist"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "playlist",
 *   dependencies = {
 *      "media": {
 *         "label" : "Media",
 *         "url" : ""
 *       }
 *    }
 * )
 */
class PlayList extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_playlist/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_playlist/assets/magnific-popup.min.js' => [],
        'components/component_playlist/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
