<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Sidebar Summary' component.
 *
 * @ComponentBuilder(
 *   id = "sidebar_summary",
 *   label = @Translation("Sidebar Summary"),
 *   group = @Translation("Sidebar"),
 *   category = @Translation("Sidebar"),
 *   template = "sidebar_summary",
 *   single_value = TRUE,
 *   dependencies = {
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    }
 * )
 */
class SidebarSummary extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_sidebar_summary/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_sidebar_summary/assets/style.js' => [],
      ],
      "version" => "VERSION",
    ];
  }

}
