<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Testimonial' component.
 *
 * @ComponentBuilder(
 *   id = "testimonial",
 *   label = @Translation("Testimonial"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "testimonial"
 * )
 */
class Testimonial extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_testimonial/assets/style.css' => [],
        ],
      ],
      "version" => "VERSION",
    ];
  }

}
