/**
 * @file
 * Javascript functionality for component article summary.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentArticleSummary = Drupal.componentArticleSummary || {};
  Drupal.behaviors.article_summary = {
    attach: function (context) {
      Drupal.componentArticleSummary.article_summary(context);
    }
  }
  Drupal.componentArticleSummary.article_summary = function (context) {
    const $article_summary =  $(once('articleSummaryItems', '.component-builder.component-item--type-article-summary', context));
    if ($article_summary.length > 0) {
      $article_summary.each(function () {
        const $this = $(this);
        const description = $this.find('.field--name-field-as-description');
        const article_summary = $('.field--name-field-article-summary');
        description.matchHeight();
        article_summary.matchHeight();
      })
    }
  }

})(jQuery, Drupal, once);
