/**
 * @file
 * Javascript functionality for component accordion.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentChart = Drupal.componentChart || {};
  Drupal.behaviors.chart = {
    attach: function (context) {
      Drupal.componentChart.initChart(context);
    }
  }
  Drupal.componentChart.initChart = function (context) {
    const $chart = $(once('chartContent', '#chart-content', context));
    if ($chart.length > 0) {
      google.charts.load('current',{packages:['corechart']});
      google.charts.setOnLoadCallback(Drupal.componentChart.drawChart);
    }
  }

  Drupal.componentChart.drawChart = function () {
    var items = drupalSettings.components.chart.items;
    if (items) {
      if (items) {
        items = JSON.parse(items);
      }
      const data = google.visualization.arrayToDataTable(items);
      var options = {
        title: drupalSettings.components.chart.title,
        legend: 'none'
      };
      const $element = document.getElementById('chart-content');
      switch (drupalSettings.components.chart.type) {
        case 'line_graph':
          var chart = new google.visualization.LineChart($element);
          chart.draw(data, options);
          break;

        case 'bar_charts':
          var chart = new google.visualization.BarChart($element);
          chart.draw(data, options);
          break;
      }
    }
  }

})(jQuery, Drupal, once);
