/**
 * @file
 * Javascript functionality for component flexible_grid.
 */

(function ($, Drupal) {

  'use strict';

  Drupal.componentFlexibleGrid = Drupal.componentFlexibleGrid || {};
  Drupal.behaviors.componentFlexibleGrid = {
    attach: function (context) {
      Drupal.componentFlexibleGrid.addClassForItem();
      // Drupal.componentFlexibleGrid.addMatchHeight();
    }
  }

  Drupal.componentFlexibleGrid.addClassForItem = function () {
    const $component_wrapper = $('.component-builder.component-wrapper.component-wrapper--type-flexible_grid')
    if ($component_wrapper.length > 0) {
      $component_wrapper.each(function () {
        let $component_item = $(this).find('.component-builder.component-item.component-item--type-flexible-grid');
        if ($component_item.length > 0) {
          $component_item.each(function () {
            let $field_item = $(this).closest('.field__item');
            $field_item.addClass($(this).attr('grid_type'));
          });
        }
      });
    }
  };

  // Drupal.componentFlexibleGrid.addMatchHeight = function () {
  //   const component_wrapper_select = '.component-builder.component-wrapper.component-wrapper--type-flexible_grid';
  //   const children_field__item = '.field__item.grid_image_text , .field__item.grid_icon';
  //   $.addMatchHeight(component_wrapper_select, children_field__item);
  // }

})(jQuery, Drupal);
