/**
 * @file
 * Javascript functionality for component highlight content.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentHighlightContent = Drupal.componentHighlightContent || {};
  Drupal.behaviors.highlight_content = {
    attach: function (context) {
      Drupal.componentHighlightContent.highlight_content(context);
    }
  }
  Drupal.componentHighlightContent.highlight_content = function (context) {
    const $highlight_content = $(once('highlightContentItems', '.component-wrapper--type-highlight_content', context));
    if ($highlight_content.length > 0) {
      $highlight_content.each(function () {
        const $this = $(this);
        const $n = $this.find('.component-item--content').length;
        const $item_content = $this.find('.component-item--content');
        const $item_content_first = $this.find('.component-item--content:first');
        $item_content_first.find('.field--name-field-small-image-2').css('display', 'none');
        for (let i = 0; i < $n; i++) {
          if (i > 0) {
            $item_content.eq(i).find('.field--name-field-large-image').css('display', 'none');
          }
        }
      })
    }
  }

})(jQuery, Drupal, once);
