/**
 * @file
 * Javascript functionality for component video and text.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentImageComparison = Drupal.componentImageComparison || {};
  Drupal.behaviors.imageComparison = {

    attach: function (context) {
        Drupal.componentImageComparison.imageComparisonHandling();
    }
  }

  Drupal.componentImageComparison.imageComparisonHandling = function () {
    const $component_item = $(once("chooseToCompare", ".component-builder.component-item.component-item--type-image-comparison"));
    if ($component_item.length > 0) {
      let $images = $component_item.find(".field--name-field-2-images > div");
      if ($images.length > 0) {
        $images.twentytwenty();

        let $twenty_container = $component_item.find(".twentytwenty-container");
        if ($twenty_container.length > 0) {
          $twenty_container.each(function () {
            $(this).css("margin", "auto");
            let widthContainer = $(this).find("img").width();
            if (widthContainer > 0) {
              $(this).css("width", widthContainer);
            }
          });
        }
      }
    }
  };

})(jQuery, Drupal, once);
