/**
 * @file
 * Javascript functionality for component push image overlap.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentPushImageOverlap = Drupal.componentPushImageOverlap || {};
  Drupal.behaviors.push_image_overlap = {
    attach: function (context) {
      Drupal.componentPushImageOverlap.push_image_overlap(context);
    }
  }
  Drupal.componentPushImageOverlap.push_image_overlap = function (context) {
    const $push_image_overlap =  $(once('pushImageOverlapItems', '.component-builder.component-item--type-push-image-overlap', context));
    if ($push_image_overlap.length > 0) {
      let $index = 0;
      $push_image_overlap.each(function () {
        const $this = $(this);
        // const $title = $this.find('.title');
        // const $content = $this.find('.component-item--content');
        const $images = $this.find('.field--name-field-image');
        if ($index % 2 == 0) {
          $images.addClass('image-left');
        }
        else {
          $images.addClass('image-right');
        }
        $index++;
      })
    }
  }

})(jQuery, Drupal, once);
