(function ($, Drupal) {
  Drupal.behaviors.componentWrapperFieldSettings = {
    attach: function (context, settings) {
      const $checkboxes = $(once('js-default-component', '.js-default-component', context));
      $checkboxes.each(function () {
        if ($(this).is(':checked')) {
          $checkboxes.not(this).attr('disabled', true);
        }
      });
      $checkboxes.on('change', function () {
        const _this = $(this);
        if (_this.is(':checked')) {
          $checkboxes.not(this).attr('disabled', true);
        } else {
          $checkboxes.attr('disabled', false);
        }
      });
    },
  };
})(jQuery, Drupal);
