/**
 * @file
 * Behaviors for the component_wrapper widget in node add form.
 */

(function ($, Drupal, once) {
  'use strict';

  Drupal.componentWrapperInline = Drupal.componentWrapperInline || {};

  Drupal.behaviors.componentWrapperInline = {
    attach: function (context) {
      $(once('btn-features', '.btn-features', context))
        .click(function () {
          const _this = $(this);
          _this.toggleClass('active');
          const $parent = _this.closest('.component-wrapper-inline-form, .component-wrapper-form');
          if ($parent) {
            $parent.find('> .group-feature-wrapper').toggleClass('active');
          }
        });

      const $selectProperties = $('.component-attributes-wrapper--composite select[name$="[options][column]"]');
      Drupal.componentWrapperInline.showFieldReferenceWithColumn($selectProperties);
      $(once('change-properties-component', '.component-attributes-wrapper--composite select[name$="[options][column]"]', context)).each(function () {
        $(this).change(function () {
          Drupal.componentWrapperInline.showFieldReferenceWithColumn($(this));
        });
      });
    }
  }

  Drupal.componentWrapperInline.showFieldReferenceWithColumn = function ($selector) {
    $selector = $($selector);
    if ($selector.length != 1) {
      return;
    }
    var numberColumn = $selector.val();
    var $parentWrapperProperties = $selector.closest('.component-wrapper-inline-form');
    var $parentIEF = $parentWrapperProperties.parent();

    let allowedColumnClass = [];
    let allColumnClass = [
      '.field--type-entity-reference.field--widget-inline-entity-form-complex.field--name-field-left-column',
      '.field--type-entity-reference.field--widget-inline-entity-form-complex.field--name-field-middle-column',
      '.field--type-entity-reference.field--widget-inline-entity-form-complex.field--name-field-right-column',
      '.field--type-entity-reference.field--widget-inline-entity-form-simple.field--name-field-left-column',
      '.field--type-entity-reference.field--widget-inline-entity-form-simple.field--name-field-middle-column',
      '.field--type-entity-reference.field--widget-inline-entity-form-simple.field--name-field-right-column',
    ];
    if (numberColumn == 1) {
      allowedColumnClass = [
        '.field--type-entity-reference.field--widget-inline-entity-form-complex.field--name-field-left-column',
        '.field--type-entity-reference.field--widget-inline-entity-form-simple.field--name-field-left-column',
      ];
    } else if (numberColumn == 2) {
      allowedColumnClass = [
        '.field--type-entity-reference.field--widget-inline-entity-form-complex.field--name-field-left-column',
        '.field--type-entity-reference.field--widget-inline-entity-form-simple.field--name-field-left-column',
        '.field--type-entity-reference.field--widget-inline-entity-form-complex.field--name-field-right-column',
        '.field--type-entity-reference.field--widget-inline-entity-form-simple.field--name-field-right-column',
      ];
    } else if (numberColumn == 3) {
      allowedColumnClass = allColumnClass;
    }

    let allowedColumnClassString = allowedColumnClass.join(',');
    let allColumnClassString = allColumnClass.join(',');
    Drupal.componentWrapperInline.displayElement($parentIEF.find(allColumnClassString), 'none');
    Drupal.componentWrapperInline.displayElement($parentIEF.find(allowedColumnClassString));
  }

  Drupal.componentWrapperInline.displayElement = function (element, display = 'block') {
    $(element).css({ 'display': display });
  };

})(jQuery, Drupal, once);
