<?php

namespace Drupal\component_builder;

/**
 * Defines the interface for component builder helper.
 */
interface ComponentBuilderHelperInterface {

  /**
   * Detect entity has field references to component wrapper.
   */
  public function getFieldsReferencedComponent($entity_id = NULL);

  /**
   * Get list components not installed.
   *
   * @return array
   *   An array of entity references to component wrapper.
   */
  public function getErrorComponents();

  /**
   * Get list bundle has field.
   */
  public function getBundleHasField(string $entity_type, string $field_name);

  /**
   * Create storage field for component wrapper field.
   */
  public function createStorageField(string $type, string $field_name);

  /**
   * Create config field for component wrapper field.
   */
  public function createReferenceComponentWrapperField(string $type, string $bundle, string $field_name, string $name);

  /**
   * Update component field.
   */
  public function updateComponentField(string $type, string $bundle, string $field_name, string $name);

  /**
   * Delete component field.
   */
  public function deleteComponentField(string $type, string $bundle, string $field_name);

  /**
   * Build table add field ajax for components.
   */
  public function buildTableComponentFields();

}
