<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Alert' component.
 *
 * @ComponentBuilder(
 *   id = "alert",
 *   label = @Translation("Alert"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "alert",
 *   single_value = TRUE,
 *   dependencies = {
 *     "color_field": {
 *       "label" : "Color field",
 *       "url" : "https://www.drupal.org/project/color_field"
 *     }
 *   }
 * )
 */
class Alert extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_alert/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_alert/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
