<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Banner Grid' component.
 *
 * @ComponentBuilder(
 *   id = "banner_grid",
 *   label = @Translation("Banner Grid"),
 *   group = @Translation("Grid Style"),
 *   category = @Translation("Grid Style"),
 *   template = "banner_grid"
 * )
 */
class BannerGrid extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_banner_grid/assets/style.css' => [],
        ],
      ],
      "version" => "VERSION",
    ];
  }

}
