<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Breadcrumb' component.
 *
 * @ComponentBuilder(
 *   id = "breadcrumb",
 *   label = @Translation("Breadcrumb"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   single_value = TRUE,
 *   template = "breadcrumb"
 * )
 */
class Breadcrumb extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_breadcrumb/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_breadcrumb/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
