<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Counter' component.
 *
 * @ComponentBuilder(
 *   id = "counter",
 *   label = @Translation("Counter"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "counter",
 *   single_value = TRUE,
 *   dependencies = {
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    }
 * )
 */
class Counter extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_counter/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_counter/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
