<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Divider Section' component.
 *
 * @ComponentBuilder(
 *   id = "divider_section",
 *   label = @Translation("Divider Section"),
 *   group = @Translation("Grid Style"),
 *   category = @Translation("Grid Style"),
 *   template = "divider_section",
 *   dependencies = {
 *      "color_field": {
 *         "label" : "Color field",
 *         "url" : "https://www.drupal.org/project/color_field"
 *       }
 *    }
 * )
 */
class DividerSection extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_divider_section/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_divider_section/assets/style.js' => [],
        'https://cdnjs.cloudflare.com/ajax/libs/jquery.matchHeight/0.7.2/jquery.matchHeight-min.js' => [
          'type' => 'external',
          'minified' => TRUE,
        ],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
