<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Fixed Topbar' component.
 *
 * @ComponentBuilder(
 *   id = "fixed_topbar",
 *   label = @Translation("Fixed Topbar"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   single_value = TRUE,
 *   template = "fixed_topbar"
 * )
 */
class FixedTopbar extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_fixed_topbar/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_fixed_topbar/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
