<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentWrapper;

/**
 * Provides 'Flexslider' component.
 *
 * @ComponentBuilder(
 *   id = "flexslider",
 *   label = @Translation("Flexslider"),
 *   group = @Translation("Slider"),
 *   category = @Translation("Slider"),
 *   template = "flexslider"
 * )
 */
class Flexslider extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {
      $component_wrapper = $variables['elements']['#component_wrapper'];
      if ($component_wrapper instanceof ComponentWrapper) {
        $type = '';
        $properties = $component_wrapper->get('field_properties')->value;
        if ($properties) {
          $properties = json_decode($properties, TRUE);
          if (isset($properties['properties']['styles']['type'])) {
            $type = $properties['properties']['styles']['type'];
          }
          $variables['attributes']['flexslider-type'][] = $type;
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_flexslider/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_flexslider/assets/jquery.flexslider-min.js' => [],
        'components/component_flexslider/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
