<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Masonry' component.
 *
 * @ComponentBuilder(
 *   id = "masonry",
 *   label = @Translation("Masonry"),
 *   group = @Translation("Grid Style"),
 *   category = @Translation("Grid Style"),
 *   template = "masonry",
 *   dependencies = {
 *      "video": {
 *         "label" : "Video",
 *         "url" : "https://www.drupal.org/project/video"
 *       }
 *    }
 * )
 */
class Masonry extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_masonry/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_masonry/assets/masonry.pkgd.min.js' => [],
        'components/component_masonry/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
