<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Pricing' component.
 *
 * @ComponentBuilder(
 *   id = "pricing",
 *   label = @Translation("Pricing"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "pricing",
 *   single_value = TRUE,
 *   dependencies = {
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    }
 * )
 */
class Pricing extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {
      $component_wrapper = $variables['elements']['#component_wrapper'];
      $number = 1;
      if ($component_wrapper instanceof ComponentWrapper) {
        $properties = $component_wrapper->get('field_properties')->value;
        if ($properties) {
          $properties = json_decode($properties, TRUE);
          foreach ($properties as $property) {
            foreach ($property as $key => $elements) {
              if ($key === "styles") {
                if (isset($elements["pricing-columns"])) {
                  $number = (int) $elements["pricing-columns"];
                }
              }
            }
          }
        }
        $variables['attributes']['data-pricing-columns'][] = $number;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_pricing/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_pricing/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
