<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Push Image Overlap' component.
 *
 * @ComponentBuilder(
 *   id = "push_image_overlap",
 *   label = @Translation("Push Image Overlap"),
 *   group = @Translation("Content style (paragraph style)"),
 *   category = @Translation("Content style (paragraph style)"),
 *   single_value = TRUE,
 *   template = "push_image_overlap"
 * )
 */
class PushImageOverlap extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_push_image_overlap/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_push_image_overlap/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
