<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentItem;

/**
 * Provides 'Push video' component.
 *
 * @ComponentBuilder(
 *   id = "push_video",
 *   label = @Translation("Push Video"),
 *   group = @Translation("Content style (paragraph style)"),
 *   category = @Translation("Content style (paragraph style)"),
 *   template = "push_video",
 *   single_value = TRUE,
 *   dependencies = {
 *      "video_embed_field": {
 *         "label" : "Video Embed Field",
 *         "url" : "https://www.drupal.org/project/video_embed_field"
 *       }
 *    }
 * )
 */
class PushVideo extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_item'])) {
      $component_item = $variables['elements']['#component_item'];
      if ($component_item instanceof ComponentItem) {
        $field_link = $component_item->get('field_pv_link')->getValue();
        if ($field_link) {
          if (!$field_link[0]['title']) {
            if ($variables['content']['title']['0']) {
              $variables['content']['field_pv_link']['0']['#title'] = $variables['content']['title'][0]['#context']['value'];
            }
          }
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_push_video/assets/style.css' => [],
        ],
      ],
      "version" => "VERSION",
    ];
  }

}
