<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Quote' component.
 *
 * @ComponentBuilder(
 *   id = "quote",
 *   label = @Translation("Quote"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "quote",
 *   single_value = TRUE,
 * )
 */
class Quote extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_quote/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_quote/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
