<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Regional Clock' component.
 *
 * @ComponentBuilder(
 *   id = "regional_clock",
 *   label = @Translation("Regional Clock"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "regional_clock",
 *   single_value = TRUE,
 *   dependencies = {
 *      "tzfield": {
 *         "label" : "Time Zone",
 *         "url" : "https://www.drupal.org/project/tzfield"
 *       }
 *    }
 * )
 */
class RegionalClock extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_regional_clock/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_regional_clock/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
