<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Service Block' component.
 *
 * @ComponentBuilder(
 *   id = "service_block",
 *   label = @Translation("Service Block"),
 *   group = @Translation("Grid Style"),
 *   category = @Translation("Grid Style"),
 *   template = "service_block",
 *   single_value = TRUE,
 *   dependencies = {
 *      "color_field": {
 *         "label" : "Color field",
 *         "url" : "https://www.drupal.org/project/color_field"
 *       },
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    }
 * )
 */
class ServiceBlock extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_service_block/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_service_block/assets/style.js' => [],
        'https://cdnjs.cloudflare.com/ajax/libs/jquery.matchHeight/0.7.2/jquery.matchHeight-min.js' => [
          'type' => 'external',
          'minified' => TRUE,
        ],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
