/**
 * @file
 * Javascript functionality for component accordion.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentAccordion = Drupal.componentAccordion || {};
  Drupal.behaviors.accordion = {
    attach: function (context) {
      Drupal.componentAccordion.accordion(context);
    }
  }
  Drupal.componentAccordion.accordion = function (context) {
    const $accordion =  $(once('accordionItems', '.component-builder.component-item--type-accordion', context));
    if ($accordion.length > 0) {
      $accordion.each(function () {
        const $this = $(this);
        const $title = $this.find('.title');
        const $content = $this.find('.component-item--content');
        $title.click(function () {
          $content.slideToggle(350);
          $this.toggleClass('component-accordion--item-show');
        })
      })
    }
  }

})(jQuery, Drupal, once);
