/**
 * @file
 * Javascript functionality for component alert.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentAlert = Drupal.componentAlert || {};
  Drupal.behaviors.alert = {
    attach: function (context) {
      Drupal.componentAlert.alert(context);
    }
  }
  Drupal.componentAlert.alert = function (context) {
    const $alert =  $(once('alertItems', '.component-builder.component-wrapper--type-alert', context));
    if ($alert.length > 0) {
      $alert.each(function () {
        const $this = $(this);
        const $alertItem = $this.find('.field--name-field-alert > div.field__item');
        const n = $alertItem.length;
        const $idItem = $this.find('button.close:first').attr('id');
        const $getColor = $this.find('.component-item--type-alert').find('.field--name-field-color').text();
        let $arrColor = $getColor.split(' ');
        const $componentItemContent = $this.find('.component-item--content');
        for (let i = 0; i < n; i++) {
          if (i == 0) {
            $componentItemContent.eq(i).css('background-color', $arrColor[i])
          }
          else {
            $componentItemContent.eq(i).css('background-color', '#' + $arrColor[i].split('#')[1])
          }
          $this.find('button.close--' + (parseInt($idItem) + i)).click( function (){
            $alertItem.eq(i).css('display', 'none');
          })
        }

      })
    }
  }

})(jQuery, Drupal, once);
