/**
 * @file
 * Javascript functionality for component grid.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentGrid = Drupal.componentGrid || {};
  Drupal.behaviors.grid = {
    attach: function (context) {
      Drupal.componentGrid.grid(context);
      Drupal.componentGrid.addMatchHeight();
    }
  }
  Drupal.componentGrid.addMatchHeight = function () {
    const $component_wrapper_selector = $('.component-builder.component-wrapper.component-wrapper--type-grid');
    const $grid_date = ".field--name-field-grid-date";
    const $link = ".field--name-field-link";
    // const $icon = ".field--name-field-icon";
    const $title = ".title-wrapper--component-grid > .title";
    $.addMatchHeight($component_wrapper_selector, $grid_date);
    $.addMatchHeight($component_wrapper_selector, $link);
    // $.addMatchHeight($component_wrapper_selector, $icon);
    $.addMatchHeight($component_wrapper_selector, $title);
  };
  Drupal.componentGrid.grid = function (context) {
    const $grid = $(once('gridItems', '.component-builder.component-item--type-grid', context));
    if ($grid.length > 0) {
      if ($('.options--display_modes--grid_quick_summary').length) {
        $('.options--display_modes--grid_quick_summary > h2').css('background-color', '#ff8c00');
        $('.options--display_modes--grid_quick_summary > h2').append('<button class ="icon-collage-event">\n' +
          '  <span id="v">v</span>' +
          '</button>');
        $('.options--display_modes--grid_quick_summary > .component-wrapper--content > .field--name-field-grid').toggle(0, function () {
          if ($('.icon-collage-event').length) {
            if ($('.icon-collage-event').css('transform') == "undefined" || $('.icon-collage-event').css('transform') == '' || $('.icon-collage-event').css('transform') == null || $('.icon-collage-event').css('transform') == 'none') {
              // $('.icon-collage-event').css('transform','rotate(180deg)');
            }
            else {
              $('.icon-collage-event').css('transform', '');
            }
          }
        });
        var checkScroll = 0;
        $(window).scroll(function () {
          var hT = $('.options--display_modes--grid_quick_summary > h2').offset().top,
            hH = $('.options--display_modes--grid_quick_summary > h2').outerHeight(),
            wH = $(window).height(),
            wS = $(this).scrollTop();
          if (wS > (hT + hH - wH) && checkScroll == 0) {
            checkScroll = 1;
            $('.options--display_modes--grid_quick_summary > .component-wrapper--content > .field--name-field-grid').slideToggle('slow', function () {
              if ($('.icon-collage-event').length) {
                if ($('.icon-collage-event').css('transform') == "undefined" || $('.icon-collage-event').css('transform') == '' || $('.icon-collage-event').css('transform') == null || $('.icon-collage-event').css('transform') == 'none') {
                  $('.icon-collage-event').css('transform', 'rotate(180deg)');
                }
                else {
                  $('.icon-collage-event').css('transform', '');
                }
              }
            });
          }
        });
        $('.options--display_modes--grid_quick_summary > h2').click(function () {
          $('.options--display_modes--grid_quick_summary > .component-wrapper--content > .field--name-field-grid').slideToggle('slow', function () {
            if ($('.icon-collage-event').length) {
              if ($('.icon-collage-event').css('transform') == "undefined" || $('.icon-collage-event').css('transform') == '' || $('.icon-collage-event').css('transform') == null || $('.icon-collage-event').css('transform') == 'none') {
                $('.icon-collage-event').css('transform', 'rotate(180deg)');
              }
              else {
                $('.icon-collage-event').css('transform', '');
              }
            }
          });
        })
      }
    }
  }

})(jQuery, Drupal, once);

