/**
 * @file
 * Javascript functionality for component accordion.
 */

(function ($, Drupal, once) {

  'use strict';
  Drupal.componentGridCarousel = Drupal.componentGridCarousel || {};
  Drupal.behaviors.gridCarousel = {
    attach: function (context) {
      Drupal.componentGridCarousel.carouselImages(context);
      Drupal.componentGridCarousel.carouselHiddenFields();
      Drupal.componentGridCarousel.addMatchHeight();
    }
  }

  Drupal.componentGridCarousel.addMatchHeight = function () {
    const $component_wrapper_selector = $('.component-builder.component-wrapper.component-wrapper--type-grid_carousel');
    const $description = ".field--name-field-gc-description";
    const $link = ".field--name-field-gc-link";
    $.addMatchHeight($component_wrapper_selector, $description);
    $.addMatchHeight($component_wrapper_selector, $link);
  };
  Drupal.componentGridCarousel.carouselImages = function (context) {
    var $carousels = $(once('wrapperGridCarousel', '.preview .component-builder.component-wrapper--type-grid_carousel, .component-builder.component-wrapper--type-grid_carousel:not(.component-builder-preview)', context));
    if ($carousels.length > 0) {
      $carousels.each(function () {
        var $this = $(this);
        let number = $this.attr('data-carousel-columns') || 2;
        number = parseInt(number);
        var $items = $this.find('.component-wrapper--content > .field--name-field-grid-carousel.field__items');
        Drupal.componentGridCarousel.carouselImageSlide($items, number);
      })
    }
  }

  Drupal.componentGridCarousel.carouselImageSlide = function ($selector, numberShow = 2) {
    if ($selector.length > 0) {
      $selector.not('.slick-initialized').slick({
        centerMode: true,
        centerPadding: '0px',
        infinite: true,
        autoplaySpeed: 2000,
        rtl: drupalSettings['components']['grid_carousel']['rtl'],
        speed: 300,
        slidesToShow: numberShow,
        slidesToScroll: 1,
        responsive: [
          {
            breakpoint: 1024,
            settings: {
              centerMode: true,
              infinite: true,
              autoplaySpeed: 2000,
              rtl: drupalSettings['components']['grid_carousel']['rtl'],
              speed: 300,
              slidesToShow: numberShow,
              slidesToScroll: 1,
              centerPadding: '0px',
            }
          },
          {
            breakpoint: 768,
            settings: {
              centerMode: true,
              autoplaySpeed: 2000,
              slidesToShow: 1,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 480,
            settings: {
              centerMode: true,
              autoplaySpeed: 2000,
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });
    }
  }

  Drupal.componentGridCarousel.carouselHiddenFields = function (context) {
    var $carouselItems = $(once('hiddenFields', '.component-builder.component-wrapper--type-grid-carousel', context));
    if ($carouselItems.length > 0) {
      $carouselItems.each(function () {
        var $this = $(this);
        var $hidden_fields = $this.attr('data-hidden-field') || [];
        $hidden_fields = JSON.parse($hidden_fields);
        if ($hidden_fields) {
          $($this.find('.slick-slide')).each(function () {
            for (let i = 0; i < $hidden_fields.length; i++) {
              $(this).find('.field--name-' + $hidden_fields[i].replace("_", "-")).each(function () {
                $(this).css("display", "none");
              });
            }
          });
        }
      })
    }
  }
})(jQuery, Drupal, once);
