/**
 * @file
 * Javascript functionality for component masonry.
 */

(function ($, Drupal) {

    'use strict';

    Drupal.componentMasonry = Drupal.componentMasonry || {};
    Drupal.behaviors.masonry = {
        attach: function (context) {
            Drupal.componentMasonry.masonryStyle();
        }
    }

    Drupal.componentMasonry.masonryStyle = function () {
        const $masonry = $(".field--name-field-masonry");
        $masonry.each(function () {
            let $this = $(this);
            let $children = $this.children('.field__item');
            $children.each(function () {
                $(this).addClass("masonry-item");
            });
        });
        $masonry.each(function () {
            const $this = $(this);
            $this.masonry({
                itemSelector: '.masonry-item',
                horizontalOrder: true,
            });

        });
    };

})(jQuery, Drupal);
