/**
 * @file
 * Javascript functionality for component carousel.
 */

(function ($, Drupal) {

    'use strict';

    Drupal.componentPricing = Drupal.componentPricing || {};
    Drupal.behaviors.pricing = {
        attach: function (context) {
            Drupal.componentPricing.addMatchHeight();
        }
    }

    Drupal.componentPricing.addMatchHeight = function () {
        const $component_wrapper_selector = $('.component-builder.component-wrapper.component-wrapper--type-pricing');
        const $title_group = ".pricing-title-group";
        const $price_group = ".pricing-price-group";
        const $price = ".pricing-price-group .field--name-field-price";
        const $admin_title = ".pricing-title-group .field--name-admin-title";
        const $pricing_services = ".field--name-field-pricing-services";
        $.addMatchHeight($component_wrapper_selector, $title_group);
        $.addMatchHeight($component_wrapper_selector, $admin_title);
        $.addMatchHeight($component_wrapper_selector, $price_group);
        $.addMatchHeight($component_wrapper_selector, $price);
        $.addMatchHeight($component_wrapper_selector, $pricing_services);
    };

})(jQuery, Drupal);
