/**
 * @file
 * Javascript functionality for component process style.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentProcessStyle = Drupal.componentProcessStyle || {};
  Drupal.behaviors.process_style = {
    attach: function (context) {
      Drupal.componentProcessStyle.addClassForCountItem();
      Drupal.componentProcessStyle.process_style(context);
    }
  }
  Drupal.componentProcessStyle.addClassForCountItem = function () {
    const $component_wrapper = $(once('componentWrapper', '.component-builder.component-wrapper.component-wrapper--type-process_style'));
    let count = $(once('countItem', ".field--name-field-process-style")).children().length;
    $component_wrapper.addClass('item-count-display--process-style-'+ count);
  }
  Drupal.componentProcessStyle.process_style = function (context) {
    const $process_style =  $(once('processStyleItems', '.component-wrapper--type-process_style', context));
    if ($process_style.length > 0) {
      $process_style.each(function () {
        const $this = $(this);
        $('.component-wrapper--type-process_style > p:first').addClass('header-text');
        $('.component-wrapper--type-process_style > p:last').addClass('footer-text');
      })
    }
  }

})(jQuery, Drupal, once);
