/**
 * @file
 * Javascript functionality for component quote.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentQuote = Drupal.componentQuote || {};
  Drupal.behaviors.quote = {
    attach: function (context) {
      Drupal.componentQuote.quote(context);
    }
  }
  Drupal.componentQuote.quote = function (context) {
    const $quote =  $(once('quoteItems', '.component-builder.component-item--type-quote', context));
    if ($quote.length > 0) {
      var checkScroll = 0;
      $(window).scroll(function () {
        var hT = $('.field--name-field-quote').offset().top,
          hH = $('.field--name-field-quote').outerHeight(),
          wH = $(window).height(),
          wS = $(this).scrollTop();
        if (wS > (hT + hH - wH) && checkScroll == 0) {
          checkScroll = 1;
          $(".content-custom").fadeOut();
          $(".content-custom").fadeIn(3000);
          $(".content-custom").animate({"margin-top": "10px"}, 1000, "linear");
          $(".content-custom").animate({"margin-bottom": "10px"}, 1000, "linear");
        }
      });
    }
  }

})(jQuery, Drupal, once);

