/**
 * @file
 * Javascript functionality for component regional clock.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentRegionalClock = Drupal.componentRegionalClock || {};
  Drupal.behaviors.regional_clock = {
    attach: function (context) {
      Drupal.componentRegionalClock.regional_clock_wrapper(context);
    }
  }
  Drupal.componentRegionalClock.regional_clock_wrapper = function (context) {
    const $regional_clock_wrapper = $(once('regionalClockWrapperItems', '.component-builder.component-wrapper--type-regional_clock', context));
    if ($regional_clock_wrapper.length > 0) {
      $regional_clock_wrapper.each(function () {
        const $this = $(this);
        const style1 = $this.hasClass('styles--format-time--HH-MM-SS-XM');
        const style2 = $this.hasClass('styles--format-time--HH-MM');
        const style3 = $this.hasClass('styles--format-time--HH-MM-XM');
        const none = $this.hasClass('styles--format-time--HH-MM-SS-XM') || $this.hasClass('styles--format-time--HH-MM') || $this.hasClass('styles--format-time--HH-MM-XM');

        const $regional_clock = $(once('regionalClockItems', '.component-builder.component-item--type-regional-clock'));
        if ($regional_clock.length > 0) {
          $regional_clock.each(function () {
            const $this = $(this);
            let $zone = $this.find('.field--name-field-time-zone').text();
            if ($zone != 'UTC') {
              const $region = $zone.split('/')[1].replace('_', ' ');
              $this.find('.time-zone').text($region);

              let myVar = setInterval(TimeZone ,1000);
              function TimeZone() {
                // Get today's date and time
                let $now = new Date();
                // const $us = $now.toLocaleString('en-US', { timeZone: 'Asia/Qatar' });
                const $time_zone = $now.toLocaleString('en-US', { timeZone: $zone });
                const arr_time = $time_zone.split(' ');
                const get_xm = arr_time[2];
                const get_date = arr_time[0];
                let get_hour = arr_time[1].split(':')[0];
                const get_minute = arr_time[1].split(':')[1];
                const get_second = arr_time[1].split(':')[2];
                if (style1 || !none) {
                  $this.find('.time').text($time_zone);
                }
                else if (style2) {
                  if (get_xm === 'PM') {
                    get_hour = parseInt(get_hour) + 12;
                  }
                  $this.find('.time').text(get_date + ' ' + get_hour + ':' + get_minute);
                }
                else if (style3) {
                  $this.find('.time').text(get_date + ' ' + get_hour + ':' + get_minute + ' ' + get_xm);
                }
              }
            }
            else {
              $this.find('.time-zone').text('UTC');
              let myVar = setInterval(TimeZone ,1000);
              function TimeZone() {
                // Get today's date and time
                let $now = new Date();
                const $time_utc = $now.toLocaleString('en-US', { timeZone: 'Europe/London' });
                const arr_time_utc = $time_utc.split(' ');
                const get_xm = arr_time_utc[2];
                const get_date = arr_time_utc[0];
                let get_hour = arr_time_utc[1].split(':')[0];
                const get_minute = arr_time_utc[1].split(':')[1];
                const get_second = arr_time_utc[1].split(':')[2];
                if (style1 || !none) {
                  $this.find('.time').text($time_zone);
                }
                else if (style2) {
                  if (get_xm === 'PM') {
                    get_hour = parseInt(get_hour) + 12;
                  }
                  $this.find('.time').text(get_date + ' ' + get_hour + ':' + get_minute);
                }
                else if (style3) {
                  $this.find('.time').text(get_date + ' ' + get_hour + ':' + get_minute + ' ' + get_xm);
                }
              }
            }
          })
        }
      })
    }
  }
  // Drupal.componentRegionalClock.regional_clock = function (context) {
  //   const $regional_clock = $('.component-builder.component-item--type-regional-clock', context).once('regionalClockItems');
  //   if ($regional_clock.length > 0) {
  //     $regional_clock.each(function () {
  //       const $this = $(this);
  //       const $zone = $this.find('.field--name-field-time-zone').text();
  //       const $region = $zone.split('/')[1].replace('_', ' ');
  //       $this.find('.time-zone').text($region);
  //
  //       let myVar = setInterval(TimeZone ,1000);
  //       function TimeZone() {
  //         // Get today's date and time
  //         let $now = new Date();
  //         // const $us = $now.toLocaleString('en-US', { timeZone: 'Asia/Qatar' });
  //         const $time_zone = $now.toLocaleString('en-US', { timeZone: $zone });
  //         const arr_time = $time_zone.split(' ');
  //         const get_xm = arr_time[2];
  //         const get_date = arr_time[0];
  //         let get_hour = arr_time[1].split(':')[0];
  //         const get_minute = arr_time[1].split(':')[1];
  //         const get_second = arr_time[1].split(':')[2];
  //         if ($('.styles--format-time--HH-MM-SS-XM').length) {
  //           $this.find('.time').text($time_zone);
  //         }
  //         else if ($('.styles--format-time--HH-MM').length) {
  //           if (get_xm === 'PM') {
  //             get_hour = parseInt(get_hour) + 12;
  //           }
  //           $this.find('.time').text(get_date + ' ' + get_hour + ':' + get_minute);
  //         }
  //         else if ($('.styles--format-time--HH-MM-XM').length) {
  //           $this.find('.time').text(get_date + ' ' + get_hour + ':' + get_minute + ' ' + get_xm);
  //         }
  //       }
  //     })
  //   }
  // }

})(jQuery, Drupal, once);
