/**
 * @file
 * Javascript functionality for component accordion.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentSlideshow = Drupal.componentSlideshow || {};
  Drupal.behaviors.slideshow = {
    attach: function (context) {
      Drupal.componentSlideshow.slideshow(context);
    }
  }
  Drupal.componentSlideshow.slideshow = function (context) {
    const $slideshows = $(once('wrapperSlideshows', '.preview .component-builder.component-wrapper--type-slideshow, .component-builder.component-wrapper--type-slideshow:not(.component-builder-preview)', context));
    if ($slideshows.length > 0) {
      $slideshows.each(function () {
        var $this = $(this);
        var $items = $this.find('.component-wrapper--content > .field--name-field-slideshow');
        Drupal.componentSlideshow.slideshowImageSlide($items, 1, true);
      })
    }
  }
  Drupal.componentSlideshow.slideshowImageSlide = function ($selector, numberShow = 2, showDot = false) {
    if ($selector.length > 0) {
      if ($selector.find('.field__item').length <= numberShow) {
        showDot = false;
      }
      $selector.not('.slick-initialized').slick({
        dots: showDot,
        rtl: drupalSettings['components']['slideshow']['rtl'],
        infinite: true,
        speed: 300,
        slidesToShow: numberShow,
        slidesToScroll: 1,
        responsive: [
          {
            breakpoint: 1024,
            settings: {
              slidesToShow: numberShow,
              slidesToScroll: 1,
              infinite: true,
              dots: showDot
            }
          },
          {
            breakpoint: 768,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 480,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });
    }
  }
})(jQuery, Drupal, once);
