/**
 * @file
 * Javascript functionality for component tabs simple.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentTabsSimple = Drupal.componentTabsSimple || {};
  Drupal.behaviors.tabs_simple = {
    attach: function (context) {
      Drupal.componentTabsSimple.tabs_simple(context);
    }
  }
  Drupal.componentTabsSimple.tabs_simple = function (context) {
    const $tabs_simple =  $(once('tabsSimpleItems', '.component-wrapper--type-tabs_simple', context));
    if ($tabs_simple.length > 0) {
      $tabs_simple.each(function () {
        const $this = $(this);
        const $count = $this.find('.tab-simple-content').length;
        let $getId = $this.find('.group-tabs-simple-content').attr('id');
        function openTabs(tabId) {
          let i;
          let $class = 'tabs-content-id--' + $getId;
          let x = document.getElementsByClassName($class);
          for (i = 0; i < x.length; i++) {
            x[i].style.display = "none";
          }
          document.getElementById(tabId).style.display = "block";
        }
        let $temp = 0;
        for (let i = 0; i < $count; i++) {
          $this.find('.tab-simple--' + (parseInt($getId) + i)).click( function () {
            openTabs('tab-simple-content--' + (parseInt($getId) + i));
            $this.find('.tab-simple--' + (parseInt($getId) + $temp)).removeClass('active');
            $this.find('.tab-simple--' + (parseInt($getId) + i)).addClass('active');
            $temp = i;
          });
        }

        if ($('.component-wrapper--type-tabs_simple > div.background').find('.field--name-field-image').length > 0) {
          $('.component-wrapper--content > .component-wrapper--type-tabs_simple').addClass('image-background-tabs-simple');
        }
        else {
          $('.component-wrapper--content > .component-wrapper--type-tabs_simple').removeClass('image-background-tabs-simple');
        }
      })
    }
  }

})(jQuery, Drupal, once);
