/**
 * @file
 * Javascript functionality for component video and text.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentTimelineItem = Drupal.componentTimelineItem || {};
  Drupal.behaviors.componentTimelineItems = {
    attach: function (context) {
      Drupal.componentTimelineItem.leftRightHandling();
    }
  }

  Drupal.componentTimelineItem.leftRightHandling = function () {
    const $component_wrapper = $('.component-builder.component-wrapper.component-wrapper--type-timeline');
    if ($component_wrapper.length > 0) {
      $component_wrapper.each(function () {
        let $field_timeline = $component_wrapper.find('div.field--name-field-timeline > .field__item');
        if ($field_timeline.length > 0) {
          $field_timeline.each(function (index) {
            if (index === 0 || index % 2 === 0) {
              $(this).addClass('timeline-item--left');
            }
            else {
              $(this).addClass('timeline-item--right');
            }
          });
        }
      });
    }
  }

})(jQuery, Drupal, once);
