<?php

namespace Drupal\component_builder;

use Drupal\Component\Plugin\DependentPluginInterface;

/**
 * Provides an interface for a navigation component plugin.
 */
interface ComponentBuilderPluginInterface extends DependentPluginInterface {

  /**
   * Returns the component label that is displayed in backend.
   */
  public function label();

  /**
   * Returns the template name this component is using.
   */
  public function getTemplateName();

  /**
   * Prepare the necessary variables for template_preprocess_node().
   */
  public function prepareVariables(array &$variables);

  /**
   * Returns a list of libraries this plugin requires.
   *
   * These libraries will be attached to the component on which the
   * component is being loaded.
   *
   * @return array
   *   An array of libraries suitable for usage in a render API #attached
   *   property.
   */
  public function getLibraries();

  /**
   * Returns a name of module.
   *
   * @return string
   *   Module name contain component.
   */
  public function getModule();

  /**
   * Returns path of component.
   */
  public function getComponentPath();

  /**
   * Returns alter wrapper.
   */
  public function isAlterWrapper();

  /**
   * Returns path template of component.
   */
  public function getTemplatePath();

  /**
   * Returns path of definition component.
   */
  public function getDefinePath();

  /**
   * Returns path of sample image component.
   */
  public function getIcon();

  /**
   * Whether this component is intended to have only one value.
   *
   * @internal this is an unstable API.
   */
  public function isSingeValue(): bool;

}
