<?php

namespace Drupal\component_builder\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class ComponentBuilderController to the custom functionality.
 */
class ComponentBuilderController extends ControllerBase {

  /**
   * The _title_callback for the component_builder.config_field route.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current node.
   *
   * @return string
   *   The page title.
   */
  public function formConfigFieldTitle(Request $request) {
    $mode = $request->get('mode');
    if ($mode) {
      return ucfirst($mode) . ' component field';
    }
    return 'Add component field';
  }

}
