<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Accordion' component.
 *
 * @ComponentBuilder(
 *   id = "accordion",
 *   label = @Translation("Accordion"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "accordion"
 * )
 */
class Accordion extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_accordion/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_accordion/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
