<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentItem;
use Drupal\component_builder\Entity\ComponentWrapper;
use Drupal\Core\Render\Markup;

/**
 * Provides 'Bubble Map' component.
 *
 * @ComponentBuilder(
 *   id = "bubble_map",
 *   label = @Translation("Bubble Map"),
 *   group = @Translation("Model"),
 *   category = @Translation("Model"),
 *   template = "bubble_map",
 *   dependencies = {
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    },
 *   single_value = TRUE,
 *   alter_wrapper = TRUE,
 * )
 */
class BubbleMap extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {

      $component_wrapper = $variables['elements']['#component_wrapper'];
      $number_display_item = 6;
      if ($component_wrapper instanceof ComponentWrapper) {
        $properties = $component_wrapper->get('field_properties')->value;
        if ($properties) {
          $properties = json_decode($properties, TRUE);
          if (isset($properties['properties']['options']['number_display_item'])) {
            $number_display_item = $properties['properties']['options']['number_display_item'];
          }
        }
      }

      if (isset($variables['content']['field_bubble_map'])) {
        $field_bubble_item = $variables['content']['field_bubble_map'];
        if (isset($field_bubble_item['#items'])) {
          $field_bubble_item_items = $field_bubble_item['#items'];
          $currentInputItem = count($field_bubble_item_items->referencedEntities());
          if ($number_display_item < $currentInputItem) {
            for ($i = $number_display_item; $i < $currentInputItem; $i++) {
              unset($variables['content']['field_bubble_map'][$i]);
            }
          }
        }
      }
    }

    if (isset($variables['elements']['#component_item'])) {
      $component_item = $variables['elements']['#component_item'];
      if ($component_item instanceof ComponentItem) {
        $content = $variables['content'];
        if ($content && isset($content['title']['0']['#context']['value'])) {
          $valueTitle = $content['title']['0']['#context']['value'];
          $markup = Markup::create('<p>' . $valueTitle . '</p>');
          $variables['content']['title']['0']['#context']['value'] = $markup;
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_bubble_map/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_bubble_map/assets/jquery.incircle.js' => [],
        'components/component_bubble_map/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
